/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.utils;

import cpw.mods.cl.JarModuleFinder;
import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.jarhandling.SecureJar;
import java.io.File;
import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.magmafoundation.magma.common.utils.JarTool;

public class BootstrapLauncher {
    public static void startServer(String[] args) {
        List<String> legacyClasspath = BootstrapLauncher.loadLegacyClassPath();
        legacyClasspath.replaceAll(s -> s.startsWith("libraries/") ? s.replace("libraries/", JarTool.getJarDir() + File.separator + "libraries" + File.separator) : s);
        System.setProperty("legacyClassPath", String.join((CharSequence)File.pathSeparator, legacyClasspath));
        String ignoreList = System.getProperty("ignoreList", "asm,securejarhandler");
        String[] ignores = ignoreList.split(",");
        HashSet previousPackages = new HashSet();
        ArrayList<SecureJar> jars = new ArrayList<SecureJar>();
        Map<String, Integer> filenameMap = BootstrapLauncher.getMergeFilenameMap();
        HashMap<Integer, List> mergeMap = new HashMap<Integer, List>();
        block0: for (String legacy : legacyClasspath) {
            Path path = Paths.get(legacy, new String[0]);
            String filename = path.getFileName().toString();
            for (String filter : ignores) {
                if (filename.startsWith(filter)) continue block0;
            }
            if (filenameMap.containsKey(filename)) {
                mergeMap.computeIfAbsent(filenameMap.get(filename), k -> new ArrayList()).add(path);
                continue;
            }
            SecureJar jar = SecureJar.from((BiPredicate)new PackageTracker(Set.copyOf(previousPackages), path), (Path[])new Path[]{path});
            Set packages = jar.getPackages();
            previousPackages.addAll(packages);
            jars.add(jar);
        }
        mergeMap.forEach((idx, paths) -> {
            Path[] pathsArray = (Path[])paths.toArray(Path[]::new);
            SecureJar jar = SecureJar.from((BiPredicate)new PackageTracker(Set.copyOf(previousPackages), pathsArray), (Path[])pathsArray);
            Set packages = jar.getPackages();
            previousPackages.addAll(packages);
            jars.add(jar);
        });
        SecureJar[] secureJarsArray = (SecureJar[])jars.toArray(SecureJar[]::new);
        List<String> allTargets = Arrays.stream(secureJarsArray).map(SecureJar::name).toList();
        JarModuleFinder jarModuleFinder = JarModuleFinder.of((SecureJar[])secureJarsArray);
        Configuration bootModuleConfiguration = ModuleLayer.boot().configuration();
        Configuration bootstrapConfiguration = bootModuleConfiguration.resolveAndBind((ModuleFinder)jarModuleFinder, ModuleFinder.ofSystem(), allTargets);
        ModuleClassLoader moduleClassLoader = new ModuleClassLoader("MC-BOOTSTRAP", bootstrapConfiguration, List.of(ModuleLayer.boot()));
        ModuleLayer.Controller layer = ModuleLayer.defineModules(bootstrapConfiguration, List.of(ModuleLayer.boot()), m -> moduleClassLoader);
        Thread.currentThread().setContextClassLoader((ClassLoader)moduleClassLoader);
        ServiceLoader<Consumer> loader = ServiceLoader.load(layer.layer(), Consumer.class);
        loader.stream().findFirst().orElseThrow().get().accept(args);
    }

    private static Map<String, Integer> getMergeFilenameMap() {
        String mergeModules = System.getProperty("mergeModules");
        if (mergeModules == null) {
            return Map.of();
        }
        HashMap<String, Integer> filenameMap = new HashMap<String, Integer>();
        int i = 0;
        for (String merge : mergeModules.split(";")) {
            String[] targets;
            for (String target : targets = merge.split(",")) {
                filenameMap.put(target, i);
            }
            ++i;
        }
        return filenameMap;
    }

    private static List<String> loadLegacyClassPath() {
        Path legacyCPFileCandidatePath;
        String legacyCpPath = System.getProperty("legacyClassPath.file");
        if (legacyCpPath != null && Files.exists(legacyCPFileCandidatePath = Paths.get(legacyCpPath, new String[0]), new LinkOption[0]) && Files.isRegularFile(legacyCPFileCandidatePath, new LinkOption[0])) {
            try {
                return Files.readAllLines(legacyCPFileCandidatePath);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load the legacy class path from the specified file: " + legacyCpPath, e);
            }
        }
        String legacyClasspath = System.getProperty("legacyClassPath", System.getProperty("java.class.path"));
        Objects.requireNonNull(legacyClasspath, "Missing legacyClassPath, cannot bootstrap");
        return Arrays.asList(legacyClasspath.split(File.pathSeparator));
    }

    private record PackageTracker(Set<String> packages, Path[] paths) implements BiPredicate<String, String>
    {
        @Override
        public boolean test(String path, String basePath) {
            if (this.packages.isEmpty() || path.startsWith("META-INF/")) {
                return true;
            }
            int idx = path.lastIndexOf(47);
            return idx < 0 || idx == path.length() - 1 || !this.packages.contains(path.substring(0, idx).replace('/', '.'));
        }
    }
}

